package gov.va.vinci.dart.biz;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="persongroup", schema="hib")
public class PersonGroup {

	@EmbeddedId
	private PersonGroupPK personGroupKey;
	
	@ManyToOne
	@JoinColumn(name="personid", insertable=false, updatable=false)
	private Person person;
	
	@ManyToOne
	@JoinColumn(name="groupid", insertable=false, updatable=false)
	private Group group;

	@Column(name="notification", columnDefinition = "boolean", length = 1, insertable=false, updatable=false)
	private Boolean notification;
	
	
	public Person getPerson() {
		return person;
	}

	public Group getGroup() {
		return group;
	}

	public Boolean getNotification() {
		return notification;
	}
	


	@Embeddable
	private static class PersonGroupPK implements Serializable {
		private static final long serialVersionUID = -546871687624441974L;

		private int personid;
		private int groupid;

		@Column(name="notification", columnDefinition = "BIT", length = 1)
		private boolean notification;

		
		public int getPersonid() {
			return personid;
		}
		public void setPersonid(int personid) {
			this.personid = personid;
		}

		public int getGroupid() {
			return groupid;
		}
		public void setGroupid(int groupid) {
			this.groupid = groupid;
		}

		public boolean isNotification() {
			return notification;
		}
		public void setNotification(boolean notification) {
			this.notification = notification;
		}
	}
}
